---
title: Configure PagerDuty · Cloudflare Notifications docs
description: Cloudflare’s Notification service supports routing notifications to
  PagerDuty. By sending notifications to PagerDuty you can leverage the same
  service definitions and escalation paths that you would for other third-party
  services that you connect to PagerDuty.
lastUpdated: 2025-09-04T16:00:58.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/notifications/get-started/configure-pagerduty/
  md: https://developers.cloudflare.com/notifications/get-started/configure-pagerduty/index.md
---

Note

This feature is only available if your account has at least one zone on a Business or higher plan. For more information, refer to our [plans](https://www.cloudflare.com/plans/).

Cloudflare’s Notification service supports routing notifications to PagerDuty. By sending notifications to PagerDuty you can leverage the same service definitions and escalation paths that you would for other third-party services that you connect to PagerDuty.

When a configuration that you have previously set up triggers a notification for PagerDuty, Cloudflare will send the notification to PagerDuty on your behalf. All of the PagerDuty services configured for the notification will receive the notification. PagerDuty will follow the service’s configuration to handle the notification appropriately. Actions like de-duping and rate limiting depend on the notification type.

To use PagerDuty as a connected service, you must [sign up for a PagerDuty account](https://www.pagerduty.com/sign-up/).

Note

According to PagerDuty, you will need an account with the following permissions to add a connected service: User, Admin, Manager, Global Admin, or Account Owner.

## Connect PagerDuty to a Cloudflare account

1. In the Cloudflare dashboard, go to the **Notifications** page.

   [Go to **Notifications**](https://dash.cloudflare.com/?to=/:account/notifications)

2. Go to **Destinations**.

3. In the **Connected notification services** card, select **Connect**.

4. Log in to your [PagerDuty account](https://www.pagerduty.com/) to connect it to your Cloudflare account.

5. Choose the services you want to use and select **Connect**.

6. The browser will navigate back to your Cloudflare dashboard. Select **Continue**.

Your new connected PagerDuty will appear in the **Connected notification services** card.

## Edit a PagerDuty connected service

To edit which PagerDuty services are connected to your Cloudflare account, you must first disconnect PagerDuty from Cloudflare, make any changes you need in PagerDuty, and then reconnect it.

Disconnecting PagerDuty will disable any notifications being sent to PagerDuty where they are currently configured. If PagerDuty was the only configured destination, disconnecting PagerDuty may result in a notification with no destination.

If other delivery destinations were selected, then those notifications will still be routed as configured.

1. In the Cloudflare dashboard, go to the **Notifications** page.

   [Go to **Notifications**](https://dash.cloudflare.com/?to=/:account/notifications)

2. Go to **Destinations**.

3. In the **Connected notification services** card, select **View** on the PagerDuty service you want to disconnect.

4. Select **Disconnect** > **Confirm**.

5. Log in to your [PagerDuty account](https://www.pagerduty.com/) and make the required changes.

6. [Reconnect PagerDuty to Cloudflare](https://developers.cloudflare.com/notifications/get-started/configure-pagerduty/).
